<?php
/**
 * Theme Excerpt
 * @package travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')){
    exit(); //exit if access it directly
}

if (!class_exists('Travelor_Excerpt')):
class Travelor_Excerpt {

    public static $length = 55;
    public static $types = array(
      'short' => 35,
      'regular' => 55,
      'long' => 100,
      'promo'=>15
    );

    public static $more = true;

    /**
    * Sets the length for the excerpt,
    * then it adds the WP filter
    * And automatically calls the_excerpt();
    *
    * @param string $new_length
    * @return void
    * @author Baylor Rae'
    */
    public static function length($new_length = 55, $more = true) {
        Travelor_Excerpt::$length = $new_length;
        Travelor_Excerpt::$more = $more;

        add_filter( 'excerpt_more', 'Travelor_Excerpt::auto_excerpt_more' );

        add_filter('excerpt_length', 'Travelor_Excerpt::new_length');

        Travelor_Excerpt::output();
    }

    public static function new_length() {
        if( isset(Travelor_Excerpt::$types[Travelor_Excerpt::$length]) )
            return Travelor_Excerpt::$types[Travelor_Excerpt::$length];
        else
            return Travelor_Excerpt::$length;
    }

    public static function output() {
        the_excerpt();
    }

    public static function continue_reading_link() {

        return '<span class="readmore"><a href="'.esc_url(get_permalink()).'">'.esc_html__('Read More','travelor').'</a></span>';
    }

    public static function auto_excerpt_more( ) {
        if (Travelor_Excerpt::$more) :
            return ' ';
        else :
            return ' ';
        endif;
    }

} //end class
endif;

if (!function_exists('Travelor_Excerpt')){

	function Travelor_Excerpt($length = 55, $more=true) {
		Travelor_Excerpt::length($length, $more);
	}

}


?>