<?php
/**
 * Theme Metabox Options
 * @package travelor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = travelor()->kses_allowed_html(array('mark'));

    $prefix = 'travelor';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'travelor'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'travelor'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'travelor'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'travelor'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'travelor'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'travelor'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'travelor'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'travelor'),
        'icon' => 'fa fa-columns',
        'fields' => Travelor_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'travelor'),
        'icon' => 'fa fa-header',
        'fields' => Travelor_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'travelor'),
        'icon' => 'fa fa-file-o',
        'fields' => Travelor_Group_Fields::Page_Container_Options('container_options')
    ));

    
    //	Tour Meta Box
    CSF::createMetabox($prefix . '_tour_options', array(
        'title' => esc_html__('Tour Options', 'travelor'),
        'post_type' => 'tour',
    ));
    CSF::createSection($prefix . '_tour_options', array(

        'fields' => array(
            array(
                'id' => 'tour_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'travelor'),
                'desc' => wp_kses(__('Select Your Icon', 'travelor'), $allowed_html)
            ),

            array(
                'id' => 'tour_location',
                'type' => 'text',
                'title' => esc_html__('tour Location', 'travelor'),
                'default' => esc_html__('Delhi, India', 'travelor'),
            ),

            array(
                'id' => 'tour_content',
                'type' => 'textarea',
                'title' => esc_html__('Tour Content', 'travelor'),
                'desc' => wp_kses(__('Enter Your tour content', 'travelor'), $allowed_html)
            ),

            array(
                'id' => 'tour_rating',
                'type' => 'textarea',
                'title' => esc_html__('Tour Rating', 'travelor'),
                'default' => esc_html__('5.00 (334)', 'travelor'),
            ),

            array(
                'id' => 'tour_day',
                'type' => 'textarea',
                'title' => esc_html__('Tour Day', 'travelor'),
                'default' => esc_html__('8 Nights - 9 Days', 'travelor'),
            ),

            array(
                'id' => 'tour_price',
                'type' => 'textarea',
                'title' => esc_html__('Tour Price', 'travelor'),
                'default' => esc_html__('$789.00', 'travelor'),
            ),

            array(
                'id' => 'tour_perperson',
                'type' => 'textarea',
                'title' => esc_html__('Tour Per Person', 'travelor'),
                'default' => esc_html__('/ Per Person', 'travelor'),
            ),
            
        )
    ));

    /*-------------------------------------
     Team Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'travelor'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Icon', 'travelor'),
        'id' => 'travelor-team-icon',
        'fields' => array(
            array(
                'id' => 'team_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'travelor'),
                'desc' => wp_kses(__('Select Your Icon', 'travelor'), $allowed_html)
            )
        )
    ));
    
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'travelor'),
        'id' => 'travelor-info',
        'fields' => array(
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'travelor'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'travelor'),
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This  category focuses on the design and construction of buildings and  arrangement of furniture and decorative elements within themarrangement', 'travelor'),
            ),
            array(
                'id' => 'description_2',
                'type' => 'textarea',
                'title' => esc_html__('Description Two', 'travelor'),
                'default' => esc_html__('This category focuses on the design and construction of buildings and the This  category focuses on the design and construction of buildings', 'travelor'),
            ),
            array(
                'id' => 'team-info',
                'type' => 'repeater',
                'title' => esc_html__('Team Info', 'travelor'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'travelor')
                    ),
                    array(
                        'id' => 'value',
                        'type' => 'text',
                        'title' => esc_html__('Value', 'travelor')
                    ),

                ),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'travelor'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'travelor'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'travelor')
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'travelor')
                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'travelor')
                    ),

                ),
            ),
        )
    ));

    //	Destination Meta Box
    CSF::createMetabox($prefix . '_destination_options', array(
        'title' => esc_html__('Destination Options', 'travelor'),
        'post_type' => 'destination',
    ));

    CSF::createSection($prefix . '_destination_options', array(
        'fields' => array(
            array(
                'id' => 'destination_subtitle',
                'type' => 'text',
                'title' => esc_html__('Destination Subtitle', 'travelor'),
                'default' => esc_html__('Destination 02', 'travelor'),
            ),
            array(
                'id' => 'destination_listing',
                'type' => 'text',
                'title' => esc_html__('Destination Listing', 'travelor'),
                'default' => esc_html__('Listing', 'travelor'),
            ),
             array(
                'id' => 'destination_description',
                'type' => 'textarea',
                'title' => esc_html__('Destination Description', 'travelor'),
                'default' => esc_html__('Touriex hires great people from a Real Transport founded of backgrounds, which simply makes', 'travelor'),
            ),
            array(
                'id' => 'destination_price',
                'type' => 'text',
                'title' => esc_html__('Destination Price', 'travelor'),
                'default' => esc_html__('From $129.00', 'travelor'),
            ),
            array(
                'id' => 'destination_icon',
                'type' => 'media',
                'title' => esc_html__('Icon', 'travelor'),
                'desc' => wp_kses(__('Select Your Icon', 'travelor'), $allowed_html)
            ),
        )
    ));

    //	Event Meta Box
    CSF::createMetabox($prefix . '_event_options', array(
        'title' => esc_html__('Event Options', 'travelor'),
        'post_type' => 'event',
    ));
    CSF::createSection($prefix . '_event_options', array(
        'fields' => array(
            array(
                'id' => 'event_icon',
                'type' => 'icon',
                'title' => esc_html__('Icon', 'travelor'),
                'desc' => wp_kses(__('Select Your Icon', 'travelor'), $allowed_html)
            ),
            array(
                'id' => 'event_date_option',
                'type' => 'text',
                'title' => esc_html__('Event Date', 'travelor'),
                'default' => esc_html__('21', 'travelor'),
            ),
            array(
                'id' => 'event_month_option',
                'type' => 'text',
                'title' => esc_html__('Event Month', 'travelor'),
                'default' => esc_html__('Feb', 'travelor'),
            ),
            array(
                'id' => 'event_year_option',
                'type' => 'text',
                'title' => esc_html__('Event Year', 'travelor'),
                'default' => esc_html__('2025', 'travelor'),
            ),
            array(
                'id' => 'event_time_option',
                'type' => 'text',
                'title' => esc_html__('Event Time', 'travelor'),
                'default' => esc_html__('10:00am', 'travelor'),
            ),
            array(
                'id' => 'event_location_option',
                'type' => 'text',
                'title' => esc_html__('Event Location', 'travelor'),
                'default' => esc_html__('684 Ann St. FL 34608', 'travelor'),
            )
        )
    ));

    //	Courses Meta Box
    CSF::createMetabox($prefix . '_courses_options', array(
        'title' => esc_html__('Courses Options', 'travelor'),
        'post_type' => 'courses',
    ));

    CSF::createSection($prefix . '_courses_options', array(
        'title' => esc_html__('Social Info', 'travelor'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'course_start_date_option',
                'type' => 'text',
                'title' => esc_html__('Start From', 'travelor'),
                'default' => esc_html__('Thursday, Nov 4, 2025', 'travelor'),
            ),
            array(
                'id' => 'study-option',
                'type' => 'repeater',
                'title' => esc_html__('Study Options', 'travelor'),
                'fields' => array(

                    array(
                        'id' => 'qualification',
                        'type' => 'text',
                        'title' => esc_html__('Qualification', 'travelor'),
                        'default' => esc_html__('Bachelor of Aviation (Hons)', 'travelor'),
                    ),
                    array(
                        'id' => 'length',
                        'type' => 'text',
                        'title' => esc_html__('Length', 'travelor'),
                        'default' => esc_html__('9 months full time', 'travelor'),
                    ),
                    array(
                        'id' => 'code',
                        'type' => 'text',
                        'title' => esc_html__('Code', 'travelor'),
                        'default' => esc_html__('ba1x', 'travelor'),
                    ),
                ),
            ),
            array(
                'id' => 'course_module_option',
                'type' => 'text',
                'title' => esc_html__('Course Module Title', 'travelor'),
                'default' => esc_html__('Download full course Module', 'travelor'),
            ),
            array(
                'id' => 'course_module_button_title',
                'type' => 'text',
                'title' => esc_html__('Course Module Button Title', 'travelor'),
                'default' => esc_html__('Download', 'travelor'),
            ),
            array(
                'id' => 'course_module_button_url',
                'type' => 'text',
                'title' => esc_html__('Course Module Button URL', 'travelor'),
                'default' => esc_html__('#', 'travelor'),
            ),
        )
    ));
}//endif