<?php
/**
 * Template part for displaying single team post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package travelor
 */

$travelor = travelor();
$travelor_meta = get_post_meta(get_the_ID(), 'travelor_team_options', true);
$img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
$img_alt = $img_id ? get_post_meta($img_id, '_wp_attachment_image_alt', true) : '';
$designation = isset($travelor_meta['designation']) && !empty($travelor_meta['designation']) ? $travelor_meta['designation'] : '';
$description = isset($travelor_meta['description']) && !empty($travelor_meta['description']) ? $travelor_meta['description'] : '';
$description_2 = isset($travelor_meta['description_2']) && !empty($travelor_meta['description_2']) ? $travelor_meta['description_2'] : '';
$team_info = isset($travelor_meta['team-info']) && !empty($travelor_meta['team-info']) ? $travelor_meta['team-info'] : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('travelor-details-content-area team-details-section'); ?>>
    <div class="entry-content">
        <?php
        the_content();
        $travelor->link_pages();
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->