<?php
/**
 * Theme Post excerpt Template
 * @package travelor
 * @since 1.0.0
 */

$travelor = travelor();
$post_meta = Travelor_Group_Fields_Value::post_meta('blog_post');
$excerpt_length = !empty($post_meta['excerpt_length']) ? $post_meta['excerpt_length'] : 55;
$readmore_text = !empty($post_meta['readmore_btn_text']) ? $post_meta['readmore_btn_text'] : esc_html__('Read More','travelor');


Travelor_Excerpt($excerpt_length);
?>
<div class="blog-bottom mt-3">
	<?php
	if($post_meta['readmore_btn']){
		printf('<a href="%1$s" class="text-main-600 fw-semibold hover-border-main-600 hover-text-main-600 d-inline-flex align-items-center tw-gap-205 group-item element-double-animation"><span class="fw-700 element-double-animation__element" data-content="%2$s">%2$s</span> <i class="ph-bold ph-arrow-right"></i> </a>',esc_url(get_the_permalink()),esc_html($readmore_text));
	}
	?>
</div>